/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_get_endpoint_addr.c,v 1.20 2006/03/05 09:27:04 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__partner.h"

MX_FUNC(mx_return_t)
mx_get_endpoint_addr(mx_endpoint_t endpoint,
		     mx_endpoint_addr_t *endpoint_addr)
{
  MX__MUTEX_LOCK(&endpoint->lock);
  mx__partner_to_addr(endpoint->myself, endpoint_addr);
  MX__MUTEX_UNLOCK(&endpoint->lock);
  return MX_SUCCESS;
}
